/***************************************************************************
	This source code is part of Anarchboot Multitasking Kernal,
	Copyright 1994, Anne Wright, anarch@ai.mit.edu
	This copy is not to be distributed in any form
	and is to be used only with express permission of the author.
****************************************************************************/

#include "332.h"
#include "tpu/pwm.h"
#include "servo.h"

int servo_min_in_tcr_counts= 600;
int servo_max_in_tcr_counts= 2200;
int servo_period_in_ns= 20000000; /* 20 milliseconds */
int servo_period_in_tcr_counts;
int servo_priority= 1;
tcr_source servo_tcr_source= tcr1;
int t2period,t2rate;

int servo_0_in_tcr_counts=2200;
int servo_180_in_tcr_counts=600;
/* tcr_source = 1 for TCR1, 2 for TCR2 */

int servo_debug=1;

void signal_error(char *fmt, ...)
{
    /* TODO:  print all args here */
    fprintf(stderr, fmt);
    breakpoint();
}

int calculate_tcr2_speed()  /* returns speed in hertz */
{  
  /* this function should be called whenever clock speed or prescale changes */
  int sys_rate=clock_rate();
  struct tmcr_struct mcr=get_tmcr();
  int prescale2=mcr.tcr2_prescale;
  
  t2rate=sys_rate>>(3+prescale2);
  t2period=period_of(t2rate);
  return(t2rate);
}

int period_to_tcr2_counts(int period,int *error)
{
  int counts;
  int tp=t2period;

  if(period<tp)
    {
      *error=tp-period;
      return(1);
    }
  else
    {
      counts=period/tp;
      *error=period-(counts*tp);
      return counts;
    }
}

void servo_init_module(tcr_source serv_tcr_source)
{
    int error;
    servo_tcr_source= serv_tcr_source;
    switch (servo_tcr_source) {
      case tcr1:
	servo_period_in_tcr_counts=
	  period_to_tcr1_counts(servo_period_in_ns, &error);
	if(servo_period_in_tcr_counts>0x7fff)
	  servo_period_in_tcr_counts=0x7fff;

	if(servo_debug) {
	  printf("Servo on TCR1: period = %x counts, %d ns, %d hz\n",
		 servo_period_in_tcr_counts,
		 tcr1_counts_to_period(servo_period_in_tcr_counts),
		 tcr1_counts_to_rate(servo_period_in_tcr_counts));
	}
	break;
      case tcr2:
	set_tcr2_source(pin_is_gate_of_div8_clock);
	calculate_tcr2_speed();
	servo_period_in_tcr_counts=
	  period_to_tcr2_counts(servo_period_in_ns, &error);
	
	break;
      default:
	signal_error("bad tcr_source in servo_init");
    }
    if (servo_period_in_tcr_counts > 0x7FFF) {
	signal_error("tcr source too slow in servo_init");
    }
}

void servo_init(int ch, int pos_in_tcr_counts)
{
    channel_control ctl=
      channel_control_output(no_force,
			     preserve_pac,
			     (servo_tcr_source == tcr1) ? o_c1_m1 : o_c2_m2);
    
    pwm_init(ch,pos_in_tcr_counts,servo_period_in_tcr_counts,
	     servo_priority,ctl);
}

void servo_enable(int ch)
{
    pwm_enable((pwm)&tpu[ch], servo_priority);
}

void servo_disable(int ch)
{
    pwm_disable((pwm)&tpu[ch]);
}

void servo_set_position(int ch, int pos_in_tcr_counts)
{
    pwm_set_times((pwm)&tpu[ch],
		  pos_in_tcr_counts, servo_period_in_tcr_counts);
}

int servo_get_position(int ch) /* returns in tcr counts */
{
    return ((pwm)&tpu[ch]) -> pwmhi;
}

/*angle is in tenths of degrees in the range 0 to 1800 */
void set_servo_angle(int ch,int angle) 
{
  int posit=servo_0_in_tcr_counts+ (angle*(servo_180_in_tcr_counts-servo_0_in_tcr_counts))/1800;  
  pwm_set_times((pwm)&tpu[ch],posit,servo_period_in_tcr_counts);
}

#if 0
/*angle is in degrees in the range 0 to 180 */
static inline void set_servo_angle(pwm servoptr,int angle) 
{
  int posit=SERVO_MIN_IN_TCR_COUNTS+ (angle*(SERVO_MAX_IN_TCR_COUNTS-SERVO_MIN_IN_TCR_COUNTS)/180);  
  pwm_set_times(servoptr,posit,SERVO_PERIOD);
}

/* returns servo position in tcr1 counts in the range SERVO_MIN_IN_TCR_COUNTS to SERVO_MAX_IN_TCR_COUNTS */
static inline int servo_position(pwm servoptr)
{
  return(servoptr->pwmhi);
}

/* returns servo angle in degrees in the range 0 to 180 */
static inline int servo_angle(pwm servoptr)
{
  int posit=servoptr->pwmhi;
  return(((posit-SERVO_MIN_IN_TCR_COUNTS)*180)/(SERVO_MAX_IN_TCR_COUNTS-SERVO_MIN_IN_TCR_COUNTS));
}

/* this stops the servo channel from emitting signals */
static inline void servo_disable(pwm servoptr)
{
  pwm_disable(servoptr);
}

/* this resumes the signals for the servo channel */
static inline void servo_enable(pwm servoptr)
{
  pwm_enable(servoptr,1);
}


set_servo_position(int s, int v)
{
}

void init_servo(int n)
{
    for (i= 0; i< NUM_SERVOS; i++) {
	pwms[i]= servo_init(servonum[i][j]);
    }
}

#endif

